/*
Standard vertex transform shader for static models (no skinning). 
Applies mirroring plane to user clip plane 0
*/
#version 430

//Standard vertex attributes, set to the default locations
layout(location = 0) in vec4 in_position;

//Uniform block for global matrices
#pragma lz append("lzsystem/shaders/generic/globalTransforms.glsl")

void main() {
	//The distance to the plane, to set the custom clip plane
	gl_ClipDistance[0] = dot((model * in_position).xyz,mirrorPlane.xyz) + mirrorPlane.w;

	gl_Position = pvm * in_position;

}